package sim;

import java.awt.*;
import java.io.*;
import java.awt.event.*;

import sim.util.SimSeparator;
import sim.util.BubbleListener;

public class WestPanel extends Panel implements ItemListener
{
	private static final String STANDARD_LIBRARY_FILE = "sim"+File.separator+"lib"+File.separator+"Standard.lib";
	public static final String STANDARD_LIBRARY_NAME = "Standard Library";
	private static final String LOAD_STRING = "Load Library ...      ";
	
	public static ToolbarListener MODE_CONTROL;
	
	public static final long BUBBLE_WAIT = 500;
	public static final int ICON_SIZE = 32;
	private EssentialModulePanel essential;
	
	private Panel components = new Panel(new CardLayout());
	private Choice library = new Choice();
	
	private LibraryDialog loadLibrary;
	
	public WestPanel()
	{
		super();
			
		WestPanel.MODE_CONTROL = new ToolbarListener();
		
		this.setBackground(MainWindow.BACKGROUND);
		this.setLayout(new BorderLayout(0, 4));
		
		this.library.add(WestPanel.LOAD_STRING);
		this.library.addMouseListener(new BubbleListener(this.library, "Component library", WestPanel.BUBBLE_WAIT));
		this.library.addItemListener(this);
		
		this.essential = new EssentialModulePanel();
		
		Panel p = new Panel(new BorderLayout(0, 4));
		p.add(BorderLayout.NORTH, new SimSeparator());
		p.add(BorderLayout.CENTER, this.essential);
		p.add(BorderLayout.SOUTH, new SimSeparator());
		this.add(BorderLayout.NORTH, p);
		
		this.loadLibrary = new LibraryDialog(this.library, this.components);
	}
	
	public void setEnabled(boolean b)
	{
		super.setEnabled(b);
	//	this.gates.setEnabled(b);
	//	this.essential.setEnabled(b);
		
		if(b)
			WestPanel.MODE_CONTROL.initialiseListeners();
		else
			WestPanel.MODE_CONTROL.removeListeners();
	}
	
	public void realSetEnabled(boolean b)
	{
		super.setEnabled(b);
	}
	
	public Dimension getPreferredSize()
	{
		return (new Dimension(150,1));		
	}
	
	public void initialize() throws SimException
	{
		WestPanel.MODE_CONTROL.getCurrnetActive().paintInset();
		
		Panel p = new Panel(new BorderLayout(0, 4));
		this.add(BorderLayout.CENTER, p);
		Panel p1 = new Panel(new FlowLayout(FlowLayout.CENTER));
		p1.add(this.library);
		p.add(BorderLayout.NORTH, p1);
		
		// load standard library
		try
		{
			//File standardLibrary = new File("");
			Reader in =  new BufferedReader(new FileReader(WestPanel.STANDARD_LIBRARY_FILE));
			this.components.add(WestPanel.STANDARD_LIBRARY_NAME, SaveLoadShortcut.GUI_FILE_LINK.loadLibrary(in));
			p.add(BorderLayout.CENTER, this.components);
		}
		catch(IOException e)
		{
			throw (new SimException("IOException: Cannot load standard library"));
		}
		catch(SimException e)
		{
			throw (new SimException("SimException: Cannot load standard library"));
		}
		
		this.library.insert(WestPanel.STANDARD_LIBRARY_NAME, 0);
	}
	
	public void itemStateChanged(ItemEvent e)
	{
		String selected = (String)e.getItem();
		int index, where;
		
		CardLayout cl = (CardLayout)this.components.getLayout();
		
		if(selected.equals(WestPanel.LOAD_STRING))
			this.loadLibrary.show();
		else
			cl.show(this.components, this.library.getSelectedItem());
	}
}
